<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckNotLoggedIn
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // dd(Auth::guard('admin')->check());
        if (Auth::guard('admin')->check()) {
            // dd('111');
            // User is logged in, redirect to a different route
            return redirect('home');
        }
        // User is not logged in, proceed with the request
        return $next($request);
        // return redirect('/login');
    }
}
