<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_settings', function (Blueprint $table) {
            $table->id();
            $table->string('type');
            $table->text('message');
            $table->timestamps();
        });

        DB::table('tbl_settings')->insert([
            ['type' => 'app_version', 'message' => '3.1.9', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'default_language', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'system_timezone', 'message' => 'Asia/Kolkata', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'app_name', 'message' => 'News', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'primary_color', 'message' => '#000000', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'secondary_color', 'message' => '#ba2028', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'auto_delete_expire_news_mode', 'message' => '0', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'app_logo_full', 'message' => 'logo.png', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'app_logo', 'message' => 'favicon.png', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'smtp_host', 'message' => 'smtp.googlemail.com', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'smtp_user', 'message' => 'SMTP User', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'smtp_password', 'message' => 'SMTP Password', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'smtp_port', 'message' => '465', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'smtp_crypto', 'message' => 'tls', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'from_name', 'message' => 'News', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'category_mode', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'subcategory_mode', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'breaking_news_mode', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'live_streaming_mode', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'comments_mode', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'weather_mode', 'message' => '0', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'location_news_mode', 'message' => '0', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'nearest_location_measure', 'message' => '1000', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'maintenance_mode', 'message' => '0', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'in_app_ads_mode', 'message' => '0', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ads_type', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'google_rewarded_video_id', 'message' => 'google Rewarded Video Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'google_interstitial_id', 'message' => 'google Interstitial Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'google_banner_id', 'message' => 'google Banner Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'google_native_unit_id', 'message' => 'google Native Unit Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'fb_rewarded_video_id', 'message' => 'fb Native Unit Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'fb_interstitial_id', 'message' => 'fb Interstitial Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'fb_banner_id', 'message' => 'fb Banner Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'fb_native_unit_id', 'message' => 'fb Native Unit Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'unity_rewarded_video_id', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'unity_interstitial_id', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'unity_banner_id', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'android_game_id', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ios_in_app_ads_mode', 'message' => '0', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ios_ads_type', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ios_fb_rewarded_video_id', 'message' => 'fb IOS Rewarded Video Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ios_fb_interstitial_id', 'message' => 'fb IOS Interstitial Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ios_fb_banner_id', 'message' => 'fb IOS Banner Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ios_fb_native_unit_id', 'message' => 'fb IOS Native Unit Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ios_google_rewarded_video_id', 'message' => 'google Rewarded Video Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ios_google_interstitial_id', 'message' => 'google Interstitial Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ios_google_banner_id', 'message' => 'google Banner Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ios_google_native_unit_id', 'message' => 'google Native Unit Id', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ios_unity_rewarded_video_id', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ios_unity_interstitial_id', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ios_unity_banner_id', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
            ['type' => 'ios_game_id', 'message' => '1', 'updated_at' => now(), 'created_at' => now()],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_settings');
    }
};
