<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_pages', function (Blueprint $table) {
            $table->id();
            $table->integer('language_id')->index('language_id');
            $table->string('title', 500);
            $table->string('slug', 500);
            $table->string('page_type', 50);
            $table->mediumText('page_content')->nullable();
            $table->string('page_icon')->nullable();
            $table->string('og_image')->nullable();
            $table->text('schema_markup')->nullable();
            $table->text('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('meta_keywords')->nullable();
            $table->tinyInteger('is_custom')->default(1)->comment('0-default, 1-custom');
            $table->tinyInteger('is_termspolicy')->default(0);
            $table->tinyInteger('is_privacypolicy')->default(0);
            $table->tinyInteger('status')->default(1)->comment('0-deactive, 1-active');
            $table->timestamps();
        });

        DB::table('tbl_pages')->insert([
            [
                'language_id' => 1,
                'title' => 'Privacy Policy',
                'slug' => 'privacy-policy',
                'page_type' => 'privacy-policy',
                'page_content' => '<p style="text-align: left;">NEWS APP &amp; CONTENT POLICY</p>',
                'page_icon' => '',
                'og_image' => '',
                'schema_markup' => '',
                'meta_title' => '',
                'meta_description' => 'Privacy Policy',
                'meta_keywords' => 'Policy',
                'is_custom' => 0,
                'is_termspolicy' => 0,
                'is_privacypolicy' => 1,
                'status' => 1,
                'updated_at' => now(),
                'created_at' => now(),
            ],
            [
                'language_id' => 1,
                'title' => 'Terms & Conditions',
                'slug' => 'terms-condition',
                'page_type' => 'terms-condition',
                'page_content' => '<p style="text-align: left;"><strong>1. Terms Conditions</strong></p>',
                'page_icon' => '',
                'og_image' => '',
                'schema_markup' => '',
                'meta_title' => '',
                'meta_description' => 'Terms & Conditions',
                'meta_keywords' => 'Terms',
                'is_custom' => 0,
                'is_termspolicy' => 1,
                'is_privacypolicy' => 0,
                'status' => 1,
                'updated_at' => now(),
                'created_at' => now(),
            ],
            [
                'language_id' => 1,
                'title' => 'Contact Us',
                'slug' => 'contact-us',
                'page_type' => 'contact-us',
                'page_content' => '<p style="text-align: center;"><strong>How can we help you?</strong></p>',
                'page_icon' => '',
                'og_image' => '',
                'schema_markup' => '',
                'meta_title' => '',
                'meta_description' => 'Contact Us',
                'meta_keywords' => 'Contact',
                'is_custom' => 0,
                'is_termspolicy' => 0,
                'is_privacypolicy' => 0,
                'status' => 1,
                'updated_at' => now(),
                'created_at' => now(),
            ],
            [
                'language_id' => 1,
                'title' => 'About Us',
                'slug' => 'about-us',
                'page_type' => 'about-us',
                'page_content' => '<p><strong>About Us:</strong></p>',
                'page_icon' => '',
                'og_image' => '',
                'schema_markup' => '',
                'meta_title' => '',
                'meta_description' => 'About Us',
                'meta_keywords' => 'About',
                'is_custom' => 0,
                'is_termspolicy' => 0,
                'is_privacypolicy' => 0,
                'status' => 1,
                'updated_at' => now(),
                'created_at' => now(),
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_pages');
    }
};
