<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('admin', function (Blueprint $table) {
            $table->id();
            $table->string('username');
            $table->text('password')->nullable();
            $table->string('email')->nullable();
            $table->text('forgot_unique_code')->nullable();
            $table->string('forgot_at')->nullable();
            $table->string('image')->nullable();
            $table->timestamps();
        });

        DB::table('admin')->insert([
            'username' => 'admin',
            'password' => Hash::make('admin123'),
            'email' => 'admin@gmail.com',
            'forgot_unique_code' => '',
            'forgot_at' => '',
            'image' => 'admin/profile.jpg',
            'updated_at' => now(),
            'created_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('admin');
    }
};
