import { BsFillPlayFill, BsPlayCircle } from 'react-icons/bs'
import Link from 'next/link'
import SwiperCore, { Navigation, Pagination, Autoplay } from 'swiper'
import { Swiper, SwiperSlide } from 'swiper/react'
import 'swiper/swiper-bundle.css'
import Skeleton from 'react-loading-skeleton'
import { placeholderImage, stripHtmlTags, translate, truncateText } from '../../utils'
import { useState } from 'react'
import VideoPlayerModal from '../videoplayer/VideoPlayerModal'
import AdSpaces from '../view/adSpaces/AdSpaces'
import CommonViewMoreDiv from './CommonViewMoreDiv'

SwiperCore.use([Navigation, Pagination, Autoplay])

const StyleOne = ({ Data }) => {
  const truncate = input => (input?.length > 180 ? `${input.substring(0, 180)}...` : input)

  const swiperOption = {
    loop: false,
    speed: 750,
    spaceBetween: 10,
    slidesPerView: 1,
    navigation: false,
    autoplay: {
      delay: 2000000,
      disableOnInteraction: false
    },
    pagination: { clickable: true }
  }

  const [Video_url, setVideo_url] = useState()
  const [modalShow, setModalShow] = useState(false)
  const [typeUrl, setTypeUrl] = useState(null)

  const handleVideoUrl = url => {
    setModalShow(true)
    setVideo_url(url)
  }

  const TypeUrl = type => {
    setTypeUrl(type)
  }

  const scrollToTop = () => {
    window.scrollTo({ top: 0, behavior: 'smooth' })
  }

  return (
    <div id='first-section'>
      {/* ad spaces */}
      {Data.ad_spaces && Data.id == Data.ad_spaces.ad_featured_section_id && Data.news_type === 'videos' ? (
        <>
          <AdSpaces ad_url={Data.ad_spaces.ad_url} ad_img={Data.ad_spaces.web_ad_image} style_web={'one'} />
        </>
      ) : null}

      {/* video section */}
      {Data.videos && Data.videos?.length > 0 ? (
        <Swiper {...swiperOption} className='custom-swiper'>
          {
            Data.videos.slice(0, 3).map(item => (
              <SwiperSlide key={item.id}>
                <div id='fs-main' className='h-100 video_style_one inner_custom_swiper'>
                  <div id='body-first-section' className='container'>
                    <div
                      className='row'
                      onClick={() => {
                        handleVideoUrl(item.content_value)
                        TypeUrl(item.content_type)
                      }}
                    >
                      <div className='col-xl-7 order-1 order-xl-0 col-12 d-flex'>
                        <div id='Left-first-section' className='my-auto'>
                          <div
                            id='Top-Description'
                            className='my-3'
                            dangerouslySetInnerHTML={{ __html: truncate(item.title) }}
                          ></div>
                        </div>
                      </div>
                      <div className='col-xl-5 order-0 order-xl-1 col-12'>
                        <div id='right-first-section'>
                          <img
                            src={item.image}
                            className='float-end fs-Newscard-image h-auto'
                            id='fs-Newscard-image'
                            alt='style one video news image'
                            onError={placeholderImage}
                          />
                          <div className='circle'>
                            <BsFillPlayFill id='btnpaly-logo' className='pulse' fill='white' size={50} />
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </SwiperSlide>
            ))
          }
          <VideoPlayerModal
            show={modalShow}
            onHide={() => setModalShow(false)}
            // backdrop="static"
            keyboard={false}
            url={Video_url}
            type_url={typeUrl}
          // title={Data[0].title}
          />
        </Swiper>
      ) : null}

      {/* ad spaces */}
      {Data.ad_spaces && Data.id == Data.ad_spaces.ad_featured_section_id && Data.news_type === 'news' ? (
        <>
          <AdSpaces ad_url={Data.ad_spaces.ad_url} ad_img={Data.ad_spaces.web_ad_image} style_web={'one'} />
        </>
      ) : null}

      {/* news section */}
      {Data && Data.news?.length > 0 ? (
        <>
          <div className='container'>

            <div id='hns-head' className='row mb-3'>
              <CommonViewMoreDiv title={Data && Data.title} desc={Data && Data.short_description} link={`/view-all/${Data.slug}`} />
            </div>
          </div>

          <Swiper {...swiperOption} className='custom-swiper'>
            {
              Data.news.slice(0, 3).map(item => (
                <SwiperSlide key={item.id}>

                  <div id='fs-main' className='h-100 inner_custom_swiper news_style_one'>
                    <div id='body-first-section' className='container'>
                      <div className='row'>
                        <div className='col-xl-7 order-1 order-xl-0 col-12 d-flex'>
                          <div id='Left-first-section' className='my-auto'>
                            <Link className='categoryTag' type='button'
                              href={{ pathname: `/news/${item.slug}`, query: { language_id: item.language_id } }}
                              // as={`/news/${item.slug}`}
                              title='detail-page'
                            >
                              {truncateText(item.category_name, 10)}
                            </Link>
                            <div className='my-3 top-title'>{truncateText(item.title, 60)}</div>
                            {
                              stripHtmlTags(item.description).length > 0 &&
                              <p className='mb-3 para'>{stripHtmlTags(item.description).substring(0, 100) + '...'}</p>
                            }
                            <div className='d-flex flex-wrap'>
                              <Link id='btnReadMore' className='mb-0 commonBtn' type='button'
                                href={{ pathname: `/news/${item.slug}`, query: { language_id: item.language_id } }}
                                // as={`/news/${item.slug}`}
                                title={translate('readmore')}
                              >
                                <b>{translate('readmore')}</b>
                              </Link>
                              {item.content_value ? (
                                <div id='btnpaly' onClick={() => handleVideoUrl(item.content_value)} className='circle'>
                                  <BsPlayCircle id='btnpaly-logo' size={40} />
                                </div>
                              ) : null}
                            </div>
                          </div>
                        </div>
                        <div className='col-xl-5 order-0 order-xl-1 col-12'>
                          <div id='right-first-section'>
                            <img
                              src={item.image}
                              className='float-end fs-Newscard-image h-auto'
                              id='fs-Newscard-image'
                              alt={item.title}
                              onError={placeholderImage}
                            />
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </SwiperSlide>
              ))
            }
            <VideoPlayerModal
              show={modalShow}
              onHide={() => setModalShow(false)}
              // backdrop="static"
              keyboard={false}
              url={Video_url}
            // title={Data[0].title}
            />
          </Swiper>
        </>

      ) : null}

      {/* ad spaces */}
      {Data.ad_spaces && Data.id == Data.ad_spaces.ad_featured_section_id && Data.news_type === 'breaking_news' ? (
        <>
          <AdSpaces ad_url={Data.ad_spaces.ad_url} ad_img={Data.ad_spaces.web_ad_image} style_web={'one'} />
        </>
      ) : null}

      {/* breaking news section */}
      {Data && Data.breaking_news?.length > 0 ? (
        <Swiper {...swiperOption} className='custom-swiper'>
          {
            Data.breaking_news.slice(0, 3).map(item => (
              <SwiperSlide key={item.id}>

                <div id='fs-main' className='h-100 inner_custom_swiper'>
                  <div id='body-first-section' className='container'>
                    <div className='row'>
                      <div className='col-xl-7 order-1 order-xl-0 col-12 d-flex'>
                        <div id='Left-first-section' className='my-auto'>
                          <div id='Top-Description' className='my-3'>
                            {item.title}
                          </div>
                          <p className='mb-3 para'>{stripHtmlTags(item.description).substring(0, 100) + '...'}</p>
                          <div className='d-flex flex-wrap align-items-center'>
                            <Link
                              id='btnReadMore'
                              className='btn mb-0'
                              type='button'
                              href={{ pathname: `/breaking-news/${item.slug}`, query: { language_id: item.language_id } }}
                              // as={`/breaking-news/${item.slug}`}
                              title={translate('readmore')}
                            >
                              <b>{translate('readmore')}</b>
                            </Link>
                            {item.content_value ? (
                              <div id='btnpaly' onClick={() => handleVideoUrl(item.content_value)} className='circle'>
                                <BsPlayCircle id='btnpaly-logo' size={40} />
                              </div>
                            ) : null}
                          </div>
                        </div>
                      </div>
                      <div className='col-xl-5 order-0 order-xl-1 col-12'>
                        <div id='right-first-section'>
                          <img
                            src={item.image}
                            className='float-end fs-Newscard-image h-auto'
                            id='fs-Newscard-image'
                            alt={item.title}
                            onError={placeholderImage}
                          />
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </SwiperSlide>
            ))
          }
          <VideoPlayerModal
            show={modalShow}
            onHide={() => setModalShow(false)}
            // backdrop="static"
            keyboard={false}
            url={Video_url}
          // title={Data[0].title}
          />
        </Swiper>
      ) : null}
    </div>
  )
}

export default StyleOne
